#install.packages("ggplot2")
#install.packages("ggpubr")
#install.packages("ggExtra")

rm(list = ls(all=T))
#加载包
library(ggplot2)
library(ggpubr)
library(ggExtra)

inputFile="HIF1AUBE2S.csv"      
gene1="HIF1A"             #第一个基因名字
gene2="UBE2S"              #第二个基因名字
setwd("D:/马明福/新文章/GEO数据库/GSE161533/相关性散点图HIF1AUBE2S")      

#读取输入文件，提取基因表达量
rt=read.csv(inputFile,sep=",",header=T,check.names=F,row.names=1)
x=as.numeric(rt[gene1,])
y=as.numeric(rt[gene2,])

#相关性分析
df1=as.data.frame(cbind(x,y))
corT=cor.test(x,y,method="spearman")
cor=corT$estimate
pValue=corT$p.value
p1=ggplot(df1, aes(x, y)) + 
			xlab(gene1)+ylab(gene2)+
			geom_point(size=2,color="#EC0101",alpha=0.5)+ geom_smooth(method="lm",formula = y ~ x) + theme_bw()+
			stat_cor(method = 'spearman', aes(x =x, y =y))
p2=ggMarginal(p1, type = "density", xparams = list(fill = "orange"),yparams = list(fill = "blue"))

#出图
pdf(file="cor1.pdf",width=5,height=4.8)
print(p1)
dev.off()

#出图2
pdf(file="cor1.density.pdf",width=5,height=5)
print(p2)
dev.off()

